function [residual, g1, g2, g3] = World_Economy_Cartel_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 62, 1);

%
% Model equations
%

T18 = exp(y(19))-params(9)*exp(y(18))^(1+params(8))/(1+params(8));
T21 = T18^(-params(14));
T33 = params(21)^(-1);
T50 = exp(y(1))*y(33)+T33*y(41)*(-(exp(y(22))*exp(y(1))*exp(y(11))))+T33*y(44)*(-(exp(y(1))*exp(y(22))));
T66 = params(12)^(1-params(4));
T85 = params(13)^(1-params(4));
T121 = exp(y(1))*exp(y(4))-exp(y(4))*params(6)*exp(y(31)-y(24))^(params(5)-1);
T176 = exp(y(6))*y(46)+params(21)*y(37)*exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))+params(21)*y(46)*(-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))))+params(21)*y(50)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
T199 = exp(y(7))*y(45)+params(21)*y(37)*exp(y(7))*params(6)*exp(y(11)*params(5))+params(21)*y(45)*(-(exp(y(7))*(1-exp(y(11)))))+params(21)*y(49)*(-(exp(y(11))*exp(y(7))));
T240 = params(21)*y(50)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))))+params(21)*y(37)*exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(24)))+params(21)*y(46)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
T262 = (-(exp(y(22))*(exp(y(1))*exp(y(11))+y(13)*(-exp(y(11)))-params(6)*params(5)*exp(y(11)*params(5)))));
T263 = y(41)*T262;
T312 = exp(y(16))^(1/params(2));
T314 = (-1)/params(2);
T316 = exp(y(15))*getPowerDeriv(exp(y(15)),T314,1);
T322 = (params(2)-1)/params(2);
T324 = exp(y(15))*getPowerDeriv(exp(y(15)),T322,1);
T334 = exp(y(17))^params(3);
T336 = exp(y(18))^(1-params(3));
T337 = T334*T336;
T338 = T337^T322;
T342 = (1-params(11))*exp(T322*y(23))*T338+params(11)*exp(y(15))^T322;
T344 = getPowerDeriv(T342,params(2)/(params(2)-1),1);
T357 = exp(y(17))^(params(3)-1);
T358 = T337^T314;
T362 = exp(y(16))*getPowerDeriv(exp(y(16)),1/params(2),1);
T371 = exp(y(18))^(-params(3));
T380 = exp(y(15))^T314;
T396 = exp(y(17))*getPowerDeriv(exp(y(17)),params(3),1);
T398 = getPowerDeriv(T337,T322,1);
T400 = (1-params(11))*exp(T322*y(23))*T336*T396*T398;
T405 = T312*exp(T322*y(23))*(1-params(11))*(1-params(3));
T408 = getPowerDeriv(T337,T314,1);
T409 = T336*T396*T408;
T412 = T396*T358*T405+T334*T405*T409;
T418 = T312*exp(T322*y(23))*(1-params(11))*params(3);
T423 = exp(y(17))*getPowerDeriv(exp(y(17)),params(3)-1,1);
T427 = (-(T336*(T357*T409*T418+T358*T418*T423)));
T453 = exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),1);
T456 = (-(params(9)*T453/(1+params(8))));
T457 = getPowerDeriv(T18,(-params(14)),1);
T458 = T456*T457;
T471 = (-(exp(T322*y(23))*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))));
T475 = exp(y(18))*getPowerDeriv(exp(y(18)),1-params(3),1);
T490 = exp(y(18))*getPowerDeriv(exp(y(18)),(-params(3)),1);
T496 = (1-params(11))*exp(T322*y(23))*T398*T334*T475;
T544 = params(9)^((-1)/params(8));
T549 = exp(y(21))*getPowerDeriv(exp(y(21)),1/params(8),1);
T560 = exp(y(22))*params(6)*params(5)*exp(y(11)*(params(5)-1))-exp(y(22))*(exp(y(1))-y(13));
T575 = (-(exp(y(22))*(exp(y(1))*exp(y(11))+(1-exp(y(11)))*y(13)-params(6)*exp(y(11)*params(5)))));
T584 = T33*y(44)*T560+exp(y(22))*y(40)+T33*y(39)*(-(exp(y(22))*(1+exp(y(20))-params(10))))+T33*y(41)*T575+T33*y(42)*(-(y(14)*exp(y(22))*(1-params(7))));
T611 = T338*(1-params(11))*T322*exp(T322*y(23));
T618 = params(21)^2;
T629 = getPowerDeriv(exp(y(31)-y(24)),params(5)-1,1);
T651 = y(50)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))))+y(46)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))))+y(37)*exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))*(-params(5));
residual(1) = T21*exp(y(1))*exp(y(4))+(-y(55))+T50+y(55)*params(21);
residual(2) = T21*(-exp(y(2)))+(-y(57))+y(48)*(-(T66*params(4)*exp(y(2)*params(4))))+exp(y(2))*y(37)+params(21)*y(57);
residual(3) = (-y(56))+y(47)*(-(T85*params(4)*exp(params(4)*y(3))))+y(43)*y(14)*T85*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1))+y(37)*exp(y(3))+params(21)*y(56);
residual(4) = T21*T121+(-y(59))+y(51)*(-exp(y(4)))+exp(y(4))*y(50)+params(21)*y(59);
residual(5) = (-y(58))+y(51)*(-exp(y(5)))+exp(y(5))*y(49)+params(21)*y(58);
residual(6) = T176;
residual(7) = T199;
residual(8) = y(48)*exp(y(8))+y(46)*(-(exp(y(8))*params(7)))+params(21)*y(48)*(-(exp(y(8))*(1-params(7))));
residual(9) = y(47)*exp(y(9))+y(45)*(-(params(7)*exp(y(9))))+params(21)*y(47)*(-((1-params(7))*exp(y(9))));
residual(10) = T240+params(21)*y(54)*(-exp(y(10)));
residual(11) = params(21)*y(49)*(-(exp(y(11))*exp(y(7))))+y(44)*exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T263+params(21)*y(37)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5))+params(21)*y(45)*(-(exp(y(7))*(-exp(y(11)))));
residual(12) = exp(y(12))*y(36);
residual(13) = y(42)*(-params(7))+y(41)+T33*y(41)*(-(exp(y(22))*(1-exp(y(11)))))+T33*exp(y(22))*y(44);
residual(14) = y(43)*T85*params(4)*exp(y(3)*(params(4)-1))+y(42)+T33*y(42)*(-(exp(y(22))*(1-params(7))));
residual(15) = y(51)*exp(y(15))+y(33)*(-(params(11)*T312*T316))+y(32)*(-(params(11)*T324*T344));
residual(16) = (-y(60))+y(37)*(-exp(y(16)))+y(35)*(-(T336*T357*T358*exp(T322*y(23))*(1-params(11))*params(3)*T362))+y(34)*(-(T371*T334*T358*T362*exp(T322*y(23))*(1-params(11))*(1-params(3))))+y(33)*(-(T380*params(11)*T362))+exp(y(16))*y(32)+params(21)*y(60);
residual(17) = y(37)*exp(y(17))+params(21)*y(32)*(-(T344*T400))+params(21)*y(34)*(-(T371*T412))+params(21)*y(35)*T427+params(21)*y(36)*(-(exp(y(18)*(1-params(3)))*exp(T322*y(23))*params(3)*exp(y(17)*params(3))))+params(21)*y(37)*(-(exp(y(17))*(1-params(10))));
residual(18) = (T121-exp(y(2)))*T458+y(40)*(-(T458*params(1)/T21))+exp(y(18))*y(38)+y(36)*T471+y(35)*(-(T357*T358*T418*T475+T336*T357*T418*T408*T334*T475))+y(34)*(-(T371*T334*T405*T408*T334*T475+T334*T358*T405*T490))+y(32)*(-(T344*T496))+params(21)*y(40)*(-((-(T458*T21*params(1)))/(T21*T21)));
residual(19) = (T121-exp(y(2)))*exp(y(19))*T457+y(40)*(-(params(1)*exp(y(19))*T457/T21))+exp(y(19))*y(37)+params(21)*y(40)*(-((-(T21*params(1)*exp(y(19))*T457))/(T21*T21)));
residual(20) = y(35)*exp(y(20))+T33*y(39)*(-(exp(y(22))*exp(y(20))));
residual(21) = y(38)*(-(T544*T549))+y(34)*exp(y(21));
residual(22) = T584;
residual(23) = y(53)+params(21)*y(53)*(-params(15))+y(36)*(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T322*exp(T322*y(23))))+y(35)*(-(T336*T357*T358*T312*(1-params(11))*params(3)*T322*exp(T322*y(23))))+y(34)*(-(T371*T334*T358*T312*(1-params(11))*(1-params(3))*T322*exp(T322*y(23))))+y(32)*(-(T344*T611))+T618*y(53)*(-params(16));
residual(24) = T21*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T629))+y(52)+T651;
residual(25) = y(55);
residual(26) = y(56);
residual(27) = y(57);
residual(28) = y(58);
residual(29) = y(59);
residual(30) = y(60);
residual(31) = T21*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T629))+y(54)*exp(y(31));
residual(32) = exp(y(16))-T342^(params(2)/(params(2)-1));
residual(33) = exp(y(1))-params(11)*T312*T380;
residual(34) = exp(y(21))-T371*T334*T358*T405;
residual(35) = exp(y(20))-T336*T357*T358*T418;
residual(36) = exp(y(12))-exp(y(18)*(1-params(3)))*exp(T322*y(23))*exp(y(17)*params(3));
residual(37) = exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))+exp(y(7))*params(6)*exp(y(11)*params(5))+exp(y(2))+exp(y(3))+exp(y(19))+exp(y(17))-(exp(y(16))+exp(y(17))*(1-params(10)));
residual(38) = exp(y(18))-T544*exp(y(21))^(1/params(8));
residual(39) = 1-exp(y(22))*(1+exp(y(20))-params(10));
residual(40) = exp(y(22))-T21*params(1)/T21;
residual(41) = y(13)-exp(y(22))*(exp(y(1))*exp(y(11))+(1-exp(y(11)))*y(13)-params(6)*exp(y(11)*params(5)));
residual(42) = y(14)-(y(14)*exp(y(22))*(1-params(7))+params(7)*y(13));
residual(43) = y(14)*T85*params(4)*exp(y(3)*(params(4)-1))-1;
residual(44) = T560;
residual(45) = exp(y(7))-(exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(9)));
residual(46) = exp(y(6))-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))+exp(y(8))*params(7));
residual(47) = exp(y(9))-((1-params(7))*exp(y(9))+T85*exp(params(4)*y(3)));
residual(48) = exp(y(8))-(exp(y(8))*(1-params(7))+T66*exp(y(2)*params(4)));
residual(49) = exp(y(5))-exp(y(11))*exp(y(7));
residual(50) = exp(y(4))-exp(y(6))*exp((-y(24)))*exp(y(10));
residual(51) = exp(y(15))-(exp(y(4))+exp(y(5)));
residual(52) = y(24)-x(1);
residual(53) = y(23)-(x(2)+y(23)*params(15)+y(23)*params(16));
residual(54) = exp(y(31))-exp(y(10));
residual(55) = y(25);
residual(56) = y(26);
residual(57) = y(27);
residual(58) = y(28);
residual(59) = y(29);
residual(60) = y(30);
lhs =y(61);
rhs =y(53);
residual(61)= lhs-rhs;
lhs =y(62);
rhs =y(23);
residual(62)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(62, 62);

  %
  % Jacobian matrix
  %

T811 = params(21)*y(49)*(-(exp(y(11))*exp(y(7))))+params(21)*y(37)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5))+params(21)*y(45)*(-(exp(y(7))*(-exp(y(11)))));
T869 = getPowerDeriv(T342,params(2)/(params(2)-1),2);
T894 = T362+exp(y(16))*exp(y(16))*getPowerDeriv(exp(y(16)),1/params(2),2);
T921 = y(34)*(-(T371*(T358*T362*exp(T322*y(23))*(1-params(11))*(1-params(3))*T396+T334*T362*exp(T322*y(23))*(1-params(11))*(1-params(3))*T409)));
T929 = y(35)*(-(T336*(T357*exp(T322*y(23))*(1-params(11))*params(3)*T362*T409+T358*exp(T322*y(23))*(1-params(11))*params(3)*T362*T423)));
T946 = y(35)*(-(T357*T358*exp(T322*y(23))*(1-params(11))*params(3)*T362*T475+T336*T357*exp(T322*y(23))*(1-params(11))*params(3)*T362*T408*T334*T475))+y(34)*(-(T371*T334*T362*exp(T322*y(23))*(1-params(11))*(1-params(3))*T408*T334*T475+T334*T358*T362*exp(T322*y(23))*(1-params(11))*(1-params(3))*T490));
T959 = y(35)*(-(T336*T357*T358*T362*(1-params(11))*params(3)*T322*exp(T322*y(23))))+y(34)*(-(T371*T334*T358*T362*(1-params(11))*(1-params(3))*T322*exp(T322*y(23))));
T968 = T396+exp(y(17))*exp(y(17))*getPowerDeriv(exp(y(17)),params(3),2);
T970 = getPowerDeriv(T337,T322,2);
T985 = getPowerDeriv(T337,T314,2);
T989 = T408*T336*T968+T336*T396*T336*T396*T985;
T1071 = y(35)*(-(T336*(T423*T358*T312*(1-params(11))*params(3)*T322*exp(T322*y(23))+T357*T409*T312*(1-params(11))*params(3)*T322*exp(T322*y(23)))));
T1078 = y(34)*(-(T371*(T396*T358*T312*(1-params(11))*(1-params(3))*T322*exp(T322*y(23))+T334*T409*T312*(1-params(11))*(1-params(3))*T322*exp(T322*y(23)))));
T1133 = getPowerDeriv(T18,(-params(14)),2);
T1137 = T457*(-(params(9)*(T453+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),2))/(1+params(8))))+T456*T456*T1133;
T1153 = T475+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),1-params(3),2);
T1242 = y(35)*(-(T475*T357*T358*T312*(1-params(11))*params(3)*T322*exp(T322*y(23))+T336*T357*T408*T334*T475*T312*(1-params(11))*params(3)*T322*exp(T322*y(23))));
T1249 = y(34)*(-(T490*T334*T358*T312*(1-params(11))*(1-params(3))*T322*exp(T322*y(23))+T371*T334*T408*T334*T475*T312*(1-params(11))*(1-params(3))*T322*exp(T322*y(23))));
T1391 = getPowerDeriv(exp(y(31)-y(24)),params(5)-1,2);
  g1(1,1)=T21*exp(y(1))*exp(y(4))+T50;
  g1(1,4)=T21*exp(y(1))*exp(y(4));
  g1(1,11)=T33*y(41)*(-(exp(y(22))*exp(y(1))*exp(y(11))));
  g1(1,18)=exp(y(1))*exp(y(4))*T458;
  g1(1,19)=exp(y(1))*exp(y(4))*exp(y(19))*T457;
  g1(1,22)=T33*y(41)*(-(exp(y(22))*exp(y(1))*exp(y(11))))+T33*y(44)*(-(exp(y(1))*exp(y(22))));
  g1(1,33)=exp(y(1));
  g1(1,41)=T33*(-(exp(y(22))*exp(y(1))*exp(y(11))));
  g1(1,44)=T33*(-(exp(y(1))*exp(y(22))));
  g1(1,55)=(-1)+params(21);
  g1(2,2)=T21*(-exp(y(2)))+exp(y(2))*y(37)+y(48)*(-(T66*params(4)*params(4)*exp(y(2)*params(4))));
  g1(2,18)=(-exp(y(2)))*T458;
  g1(2,19)=(-exp(y(2)))*exp(y(19))*T457;
  g1(2,37)=exp(y(2));
  g1(2,48)=(-(T66*params(4)*exp(y(2)*params(4))));
  g1(2,57)=(-1)+params(21);
  g1(3,3)=y(47)*(-(T85*params(4)*params(4)*exp(params(4)*y(3))))+y(37)*exp(y(3))+y(43)*y(14)*T85*params(4)*(params(4)-1)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,14)=y(43)*T85*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,37)=exp(y(3));
  g1(3,43)=y(14)*T85*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,47)=(-(T85*params(4)*exp(params(4)*y(3))));
  g1(3,56)=(-1)+params(21);
  g1(4,1)=T21*exp(y(1))*exp(y(4));
  g1(4,4)=T21*T121+y(51)*(-exp(y(4)))+exp(y(4))*y(50);
  g1(4,18)=T121*T458;
  g1(4,19)=T121*exp(y(19))*T457;
  g1(4,24)=T21*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T629));
  g1(4,31)=T21*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T629));
  g1(4,50)=exp(y(4));
  g1(4,51)=(-exp(y(4)));
  g1(4,59)=(-1)+params(21);
  g1(5,5)=y(51)*(-exp(y(5)))+exp(y(5))*y(49);
  g1(5,49)=exp(y(5));
  g1(5,51)=(-exp(y(5)));
  g1(5,58)=(-1)+params(21);
  g1(6,6)=T176;
  g1(6,10)=T240;
  g1(6,24)=params(21)*y(37)*exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))*(-params(5))+params(21)*y(46)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))))+params(21)*y(50)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))));
  g1(6,37)=params(21)*exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)));
  g1(6,46)=exp(y(6))+params(21)*(-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))));
  g1(6,50)=params(21)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(7,7)=T199;
  g1(7,11)=T811;
  g1(7,37)=params(21)*exp(y(7))*params(6)*exp(y(11)*params(5));
  g1(7,45)=exp(y(7))+params(21)*(-(exp(y(7))*(1-exp(y(11)))));
  g1(7,49)=params(21)*(-(exp(y(11))*exp(y(7))));
  g1(8,8)=y(48)*exp(y(8))+y(46)*(-(exp(y(8))*params(7)))+params(21)*y(48)*(-(exp(y(8))*(1-params(7))));
  g1(8,46)=(-(exp(y(8))*params(7)));
  g1(8,48)=exp(y(8))+params(21)*(-(exp(y(8))*(1-params(7))));
  g1(9,9)=y(47)*exp(y(9))+y(45)*(-(params(7)*exp(y(9))))+params(21)*y(47)*(-((1-params(7))*exp(y(9))));
  g1(9,45)=(-(params(7)*exp(y(9))));
  g1(9,47)=exp(y(9))+params(21)*(-((1-params(7))*exp(y(9))));
  g1(10,6)=T240;
  g1(10,10)=params(21)*y(54)*(-exp(y(10)))+params(21)*y(50)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))))+params(21)*y(46)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))))+params(21)*y(37)*exp(y(6))*params(6)*params(5)*params(5)*exp(params(5)*(y(10)-y(24)));
  g1(10,24)=params(21)*y(50)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))))+params(21)*y(46)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))))+params(21)*y(37)*exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(24)))*(-params(5));
  g1(10,37)=params(21)*exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(24)));
  g1(10,46)=params(21)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
  g1(10,50)=params(21)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(10,54)=params(21)*(-exp(y(10)));
  g1(11,1)=y(41)*(-(exp(y(22))*exp(y(1))*exp(y(11))));
  g1(11,7)=T811;
  g1(11,11)=params(21)*y(49)*(-(exp(y(11))*exp(y(7))))+params(21)*y(45)*(-(exp(y(7))*(-exp(y(11)))))+y(44)*exp(y(22))*params(6)*params(5)*(params(5)-1)*(params(5)-1)*exp(y(11)*(params(5)-1))+y(41)*(-(exp(y(22))*(exp(y(1))*exp(y(11))+y(13)*(-exp(y(11)))-params(6)*params(5)*params(5)*exp(y(11)*params(5)))))+params(21)*y(37)*exp(y(7))*params(6)*params(5)*params(5)*exp(y(11)*params(5));
  g1(11,13)=y(41)*(-(exp(y(22))*(-exp(y(11)))));
  g1(11,22)=y(44)*exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T263;
  g1(11,37)=params(21)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5));
  g1(11,41)=T262;
  g1(11,44)=exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1));
  g1(11,45)=params(21)*(-(exp(y(7))*(-exp(y(11)))));
  g1(11,49)=params(21)*(-(exp(y(11))*exp(y(7))));
  g1(12,12)=exp(y(12))*y(36);
  g1(12,36)=exp(y(12));
  g1(13,11)=T33*y(41)*(-(exp(y(22))*(-exp(y(11)))));
  g1(13,22)=T33*y(41)*(-(exp(y(22))*(1-exp(y(11)))))+T33*exp(y(22))*y(44);
  g1(13,41)=1+T33*(-(exp(y(22))*(1-exp(y(11)))));
  g1(13,42)=(-params(7));
  g1(13,44)=T33*exp(y(22));
  g1(14,3)=y(43)*T85*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(14,22)=T33*y(42)*(-(exp(y(22))*(1-params(7))));
  g1(14,42)=1+T33*(-(exp(y(22))*(1-params(7))));
  g1(14,43)=T85*params(4)*exp(y(3)*(params(4)-1));
  g1(15,15)=y(51)*exp(y(15))+y(33)*(-(params(11)*T312*(T316+exp(y(15))*exp(y(15))*getPowerDeriv(exp(y(15)),T314,2))))+y(32)*(-(T344*params(11)*(T324+exp(y(15))*exp(y(15))*getPowerDeriv(exp(y(15)),T322,2))+params(11)*T324*params(11)*T324*T869));
  g1(15,16)=y(33)*(-(T316*params(11)*T362));
  g1(15,17)=y(32)*(-(params(11)*T324*T400*T869));
  g1(15,18)=y(32)*(-(params(11)*T324*T496*T869));
  g1(15,23)=y(32)*(-(params(11)*T324*T611*T869));
  g1(15,32)=(-(params(11)*T324*T344));
  g1(15,33)=(-(params(11)*T312*T316));
  g1(15,51)=exp(y(15));
  g1(16,15)=y(33)*(-(T316*params(11)*T362));
  g1(16,16)=y(37)*(-exp(y(16)))+y(35)*(-(T336*T357*T358*exp(T322*y(23))*(1-params(11))*params(3)*T894))+y(34)*(-(T371*T334*T358*exp(T322*y(23))*(1-params(11))*(1-params(3))*T894))+exp(y(16))*y(32)+y(33)*(-(T380*params(11)*T894));
  g1(16,17)=T921+T929;
  g1(16,18)=T946;
  g1(16,23)=T959;
  g1(16,32)=exp(y(16));
  g1(16,33)=(-(T380*params(11)*T362));
  g1(16,34)=(-(T371*T334*T358*T362*exp(T322*y(23))*(1-params(11))*(1-params(3))));
  g1(16,35)=(-(T336*T357*T358*exp(T322*y(23))*(1-params(11))*params(3)*T362));
  g1(16,37)=(-exp(y(16)));
  g1(16,60)=(-1)+params(21);
  g1(17,15)=params(21)*y(32)*(-(T400*params(11)*T324*T869));
  g1(17,16)=params(21)*T921+params(21)*T929;
  g1(17,17)=y(37)*exp(y(17))+params(21)*y(37)*(-(exp(y(17))*(1-params(10))))+params(21)*y(32)*(-(T400*T400*T869+T344*(1-params(11))*exp(T322*y(23))*(T398*T336*T968+T336*T396*T336*T396*T970)))+params(21)*y(34)*(-(T371*(T358*T405*T968+T396*T405*T409+T396*T405*T409+T334*T405*T989)))+params(21)*y(35)*(-(T336*(T409*T418*T423+T357*T418*T989+T409*T418*T423+T358*T418*(T423+exp(y(17))*exp(y(17))*getPowerDeriv(exp(y(17)),params(3)-1,2)))))+params(21)*y(36)*(-(exp(y(18)*(1-params(3)))*exp(T322*y(23))*params(3)*params(3)*exp(y(17)*params(3))));
  g1(17,18)=params(21)*y(32)*(-(T400*T496*T869+T344*(1-params(11))*exp(T322*y(23))*(T398*T396*T475+T336*T396*T334*T475*T970)))+params(21)*y(34)*(-(T412*T490+T371*(T396*T405*T408*T334*T475+T334*T405*(T408*T396*T475+T336*T396*T334*T475*T985))))+params(21)*y(35)*(-((T357*T409*T418+T358*T418*T423)*T475+T336*(T423*T418*T408*T334*T475+T357*T418*(T408*T396*T475+T336*T396*T334*T475*T985))))+params(21)*y(36)*(-(exp(T322*y(23))*params(3)*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))));
  g1(17,23)=params(21)*y(32)*(-(T344*T336*T396*T398*(1-params(11))*T322*exp(T322*y(23))+T400*T611*T869))+params(21)*T1078+params(21)*T1071+params(21)*y(36)*(-(exp(y(18)*(1-params(3)))*params(3)*exp(y(17)*params(3))*T322*exp(T322*y(23))));
  g1(17,32)=params(21)*(-(T344*T400));
  g1(17,34)=params(21)*(-(T371*T412));
  g1(17,35)=params(21)*T427;
  g1(17,36)=params(21)*(-(exp(y(18)*(1-params(3)))*exp(T322*y(23))*params(3)*exp(y(17)*params(3))));
  g1(17,37)=exp(y(17))+params(21)*(-(exp(y(17))*(1-params(10))));
  g1(18,1)=exp(y(1))*exp(y(4))*T458;
  g1(18,2)=(-exp(y(2)))*T458;
  g1(18,4)=T121*T458;
  g1(18,15)=y(32)*(-(T496*params(11)*T324*T869));
  g1(18,16)=T946;
  g1(18,17)=y(36)*(-(exp(T322*y(23))*params(3)*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))))+y(35)*(-((T357*T409*T418+T358*T418*T423)*T475+T336*(T423*T418*T408*T334*T475+T357*T418*(T334*T475*T336*T396*T985+T408*T396*T475))))+y(34)*(-(T371*(T396*T405*T408*T334*T475+T334*T405*(T334*T475*T336*T396*T985+T408*T396*T475))+T412*T490))+y(32)*(-(T496*T400*T869+T344*(1-params(11))*exp(T322*y(23))*(T334*T475*T336*T396*T970+T398*T396*T475)));
  g1(18,18)=(T121-exp(y(2)))*T1137+y(40)*(-((T21*params(1)*T1137-T458*T458*params(1))/(T21*T21)))+exp(y(18))*y(38)+y(36)*(-(exp(T322*y(23))*exp(y(17)*params(3))*(1-params(3))*(1-params(3))*exp(y(18)*(1-params(3)))))+y(35)*(-(T475*T357*T418*T408*T334*T475+T357*T358*T418*T1153+T475*T357*T418*T408*T334*T475+T336*T357*T418*(T334*T475*T334*T475*T985+T408*T334*T1153)))+y(34)*(-(T334*T405*T408*T334*T475*T490+T371*T334*T405*(T334*T475*T334*T475*T985+T408*T334*T1153)+T334*T405*T408*T334*T475*T490+T334*T358*T405*(T490+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),(-params(3)),2))))+y(32)*(-(T496*T496*T869+T344*(1-params(11))*exp(T322*y(23))*(T334*T475*T334*T475*T970+T398*T334*T1153)))+params(21)*y(40)*(-((T21*T21*(-(T458*T458*params(1)+T21*params(1)*T1137))-(-(T458*T21*params(1)))*(T21*T458+T21*T458))/(T21*T21*T21*T21)));
  g1(18,19)=(T121-exp(y(2)))*T456*exp(y(19))*T1133+y(40)*(-((T21*params(1)*T456*exp(y(19))*T1133-T458*params(1)*exp(y(19))*T457)/(T21*T21)))+params(21)*y(40)*(-((T21*T21*(-(T458*params(1)*exp(y(19))*T457+T21*params(1)*T456*exp(y(19))*T1133))-(-(T458*T21*params(1)))*(T21*exp(y(19))*T457+T21*exp(y(19))*T457))/(T21*T21*T21*T21)));
  g1(18,23)=y(36)*(-((1-params(3))*exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T322*exp(T322*y(23))))+T1242+T1249+y(32)*(-(T344*T398*T334*T475*(1-params(11))*T322*exp(T322*y(23))+T496*T611*T869));
  g1(18,24)=T458*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T629));
  g1(18,31)=T458*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T629));
  g1(18,32)=(-(T344*T496));
  g1(18,34)=(-(T371*T334*T405*T408*T334*T475+T334*T358*T405*T490));
  g1(18,35)=(-(T357*T358*T418*T475+T336*T357*T418*T408*T334*T475));
  g1(18,36)=T471;
  g1(18,38)=exp(y(18));
  g1(18,40)=(-(T458*params(1)/T21))+params(21)*(-((-(T458*T21*params(1)))/(T21*T21)));
  g1(19,1)=exp(y(1))*exp(y(4))*exp(y(19))*T457;
  g1(19,2)=(-exp(y(2)))*exp(y(19))*T457;
  g1(19,4)=T121*exp(y(19))*T457;
  g1(19,18)=(T121-exp(y(2)))*exp(y(19))*T456*T1133+y(40)*(-((T21*params(1)*exp(y(19))*T456*T1133-T458*params(1)*exp(y(19))*T457)/(T21*T21)))+params(21)*y(40)*(-((T21*T21*(-(T458*params(1)*exp(y(19))*T457+T21*params(1)*exp(y(19))*T456*T1133))-(-(T21*params(1)*exp(y(19))*T457))*(T21*T458+T21*T458))/(T21*T21*T21*T21)));
  g1(19,19)=(T121-exp(y(2)))*(exp(y(19))*T457+exp(y(19))*exp(y(19))*T1133)+y(40)*(-((T21*params(1)*(exp(y(19))*T457+exp(y(19))*exp(y(19))*T1133)-exp(y(19))*T457*params(1)*exp(y(19))*T457)/(T21*T21)))+exp(y(19))*y(37)+params(21)*y(40)*(-((T21*T21*(-(exp(y(19))*T457*params(1)*exp(y(19))*T457+T21*params(1)*(exp(y(19))*T457+exp(y(19))*exp(y(19))*T1133)))-(-(T21*params(1)*exp(y(19))*T457))*(T21*exp(y(19))*T457+T21*exp(y(19))*T457))/(T21*T21*T21*T21)));
  g1(19,24)=exp(y(19))*T457*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T629));
  g1(19,31)=exp(y(19))*T457*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T629));
  g1(19,37)=exp(y(19));
  g1(19,40)=(-(params(1)*exp(y(19))*T457/T21))+params(21)*(-((-(T21*params(1)*exp(y(19))*T457))/(T21*T21)));
  g1(20,20)=y(35)*exp(y(20))+T33*y(39)*(-(exp(y(22))*exp(y(20))));
  g1(20,22)=T33*y(39)*(-(exp(y(22))*exp(y(20))));
  g1(20,35)=exp(y(20));
  g1(20,39)=T33*(-(exp(y(22))*exp(y(20))));
  g1(21,21)=y(34)*exp(y(21))+y(38)*(-(T544*(T549+exp(y(21))*exp(y(21))*getPowerDeriv(exp(y(21)),1/params(8),2))));
  g1(21,34)=exp(y(21));
  g1(21,38)=(-(T544*T549));
  g1(22,1)=T33*y(41)*(-(exp(y(22))*exp(y(1))*exp(y(11))))+T33*y(44)*(-(exp(y(1))*exp(y(22))));
  g1(22,11)=T33*y(44)*exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T33*T263;
  g1(22,13)=T33*y(41)*(-(exp(y(22))*(1-exp(y(11)))))+T33*exp(y(22))*y(44);
  g1(22,14)=T33*y(42)*(-(exp(y(22))*(1-params(7))));
  g1(22,20)=T33*y(39)*(-(exp(y(22))*exp(y(20))));
  g1(22,22)=T584;
  g1(22,39)=T33*(-(exp(y(22))*(1+exp(y(20))-params(10))));
  g1(22,40)=exp(y(22));
  g1(22,41)=T33*T575;
  g1(22,42)=T33*(-(y(14)*exp(y(22))*(1-params(7))));
  g1(22,44)=T33*T560;
  g1(23,15)=y(32)*(-(T611*params(11)*T324*T869));
  g1(23,16)=T959;
  g1(23,17)=y(36)*(-(exp(y(18)*(1-params(3)))*params(3)*exp(y(17)*params(3))*T322*exp(T322*y(23))))+T1071+T1078+y(32)*(-(T611*T400*T869+T344*T336*T396*T398*(1-params(11))*T322*exp(T322*y(23))));
  g1(23,18)=y(36)*(-((1-params(3))*exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T322*exp(T322*y(23))))+T1242+T1249+y(32)*(-(T611*T496*T869+T344*T398*T334*T475*(1-params(11))*T322*exp(T322*y(23))));
  g1(23,23)=y(36)*(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T322*T322*exp(T322*y(23))))+y(35)*(-(T336*T357*T358*T312*(1-params(11))*params(3)*T322*T322*exp(T322*y(23))))+y(34)*(-(T371*T334*T358*T312*(1-params(11))*(1-params(3))*T322*T322*exp(T322*y(23))))+y(32)*(-(T611*T611*T869+T344*T338*(1-params(11))*T322*T322*exp(T322*y(23))));
  g1(23,32)=(-(T344*T611));
  g1(23,34)=(-(T371*T334*T358*T312*(1-params(11))*(1-params(3))*T322*exp(T322*y(23))));
  g1(23,35)=(-(T336*T357*T358*T312*(1-params(11))*params(3)*T322*exp(T322*y(23))));
  g1(23,36)=(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T322*exp(T322*y(23))));
  g1(23,53)=1+params(21)*(-params(15))+T618*(-params(16));
  g1(24,4)=T21*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T629));
  g1(24,6)=T651;
  g1(24,10)=y(50)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))))+y(46)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))))+y(37)*exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(24)))*(-params(5));
  g1(24,18)=T458*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T629));
  g1(24,19)=exp(y(19))*T457*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T629));
  g1(24,24)=T21*(-(exp(y(4))*params(6)*(exp(y(31)-y(24))*T629+(-exp(y(31)-y(24)))*(-exp(y(31)-y(24)))*T1391)))+y(50)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))))+y(46)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))))+y(37)*exp(y(6))*params(6)*(-params(5))*exp(params(5)*(y(10)-y(24)))*(-params(5));
  g1(24,31)=T21*(-(exp(y(4))*params(6)*((-exp(y(31)-y(24)))*T629+(-exp(y(31)-y(24)))*exp(y(31)-y(24))*T1391)));
  g1(24,37)=exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))*(-params(5));
  g1(24,46)=(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))));
  g1(24,50)=(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))));
  g1(24,52)=1;
  g1(25,55)=1;
  g1(26,56)=1;
  g1(27,57)=1;
  g1(28,58)=1;
  g1(29,59)=1;
  g1(30,60)=1;
  g1(31,4)=T21*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T629));
  g1(31,18)=T458*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T629));
  g1(31,19)=exp(y(19))*T457*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T629));
  g1(31,24)=T21*(-(exp(y(4))*params(6)*((-exp(y(31)-y(24)))*T629+exp(y(31)-y(24))*(-exp(y(31)-y(24)))*T1391)));
  g1(31,31)=y(54)*exp(y(31))+T21*(-(exp(y(4))*params(6)*(exp(y(31)-y(24))*T629+exp(y(31)-y(24))*exp(y(31)-y(24))*T1391)));
  g1(31,54)=exp(y(31));
  g1(32,15)=(-(params(11)*T324*T344));
  g1(32,16)=exp(y(16));
  g1(32,17)=(-(T344*T400));
  g1(32,18)=(-(T344*T496));
  g1(32,23)=(-(T344*T611));
  g1(33,1)=exp(y(1));
  g1(33,15)=(-(params(11)*T312*T316));
  g1(33,16)=(-(T380*params(11)*T362));
  g1(34,16)=(-(T371*T334*T358*T362*exp(T322*y(23))*(1-params(11))*(1-params(3))));
  g1(34,17)=(-(T371*T412));
  g1(34,18)=(-(T371*T334*T405*T408*T334*T475+T334*T358*T405*T490));
  g1(34,21)=exp(y(21));
  g1(34,23)=(-(T371*T334*T358*T312*(1-params(11))*(1-params(3))*T322*exp(T322*y(23))));
  g1(35,16)=(-(T336*T357*T358*exp(T322*y(23))*(1-params(11))*params(3)*T362));
  g1(35,17)=T427;
  g1(35,18)=(-(T357*T358*T418*T475+T336*T357*T418*T408*T334*T475));
  g1(35,20)=exp(y(20));
  g1(35,23)=(-(T336*T357*T358*T312*(1-params(11))*params(3)*T322*exp(T322*y(23))));
  g1(36,12)=exp(y(12));
  g1(36,17)=(-(exp(y(18)*(1-params(3)))*exp(T322*y(23))*params(3)*exp(y(17)*params(3))));
  g1(36,18)=T471;
  g1(36,23)=(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T322*exp(T322*y(23))));
  g1(37,2)=exp(y(2));
  g1(37,3)=exp(y(3));
  g1(37,6)=exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)));
  g1(37,7)=exp(y(7))*params(6)*exp(y(11)*params(5));
  g1(37,10)=exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(24)));
  g1(37,11)=exp(y(7))*params(6)*params(5)*exp(y(11)*params(5));
  g1(37,16)=(-exp(y(16)));
  g1(37,17)=exp(y(17))-exp(y(17))*(1-params(10));
  g1(37,19)=exp(y(19));
  g1(37,24)=exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))*(-params(5));
  g1(38,18)=exp(y(18));
  g1(38,21)=(-(T544*T549));
  g1(39,20)=(-(exp(y(22))*exp(y(20))));
  g1(39,22)=(-(exp(y(22))*(1+exp(y(20))-params(10))));
  g1(40,18)=(-((T21*T458*params(1)-T458*T21*params(1))/(T21*T21)));
  g1(40,19)=(-((T21*params(1)*exp(y(19))*T457-T21*params(1)*exp(y(19))*T457)/(T21*T21)));
  g1(40,22)=exp(y(22));
  g1(41,1)=(-(exp(y(22))*exp(y(1))*exp(y(11))));
  g1(41,11)=T262;
  g1(41,13)=1-exp(y(22))*(1-exp(y(11)));
  g1(41,22)=T575;
  g1(42,13)=(-params(7));
  g1(42,14)=1-exp(y(22))*(1-params(7));
  g1(42,22)=(-(y(14)*exp(y(22))*(1-params(7))));
  g1(43,3)=y(14)*T85*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(43,14)=T85*params(4)*exp(y(3)*(params(4)-1));
  g1(44,1)=(-(exp(y(1))*exp(y(22))));
  g1(44,11)=exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1));
  g1(44,13)=exp(y(22));
  g1(44,22)=T560;
  g1(45,7)=exp(y(7))-exp(y(7))*(1-exp(y(11)));
  g1(45,9)=(-(params(7)*exp(y(9))));
  g1(45,11)=(-(exp(y(7))*(-exp(y(11)))));
  g1(46,6)=exp(y(6))-exp(y(6))*(1-exp((-y(24)))*exp(y(10)));
  g1(46,8)=(-(exp(y(8))*params(7)));
  g1(46,10)=(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
  g1(46,24)=(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))));
  g1(47,3)=(-(T85*params(4)*exp(params(4)*y(3))));
  g1(47,9)=exp(y(9))-(1-params(7))*exp(y(9));
  g1(48,2)=(-(T66*params(4)*exp(y(2)*params(4))));
  g1(48,8)=exp(y(8))-exp(y(8))*(1-params(7));
  g1(49,5)=exp(y(5));
  g1(49,7)=(-(exp(y(11))*exp(y(7))));
  g1(49,11)=(-(exp(y(11))*exp(y(7))));
  g1(50,4)=exp(y(4));
  g1(50,6)=(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(50,10)=(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(50,24)=(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))));
  g1(51,4)=(-exp(y(4)));
  g1(51,5)=(-exp(y(5)));
  g1(51,15)=exp(y(15));
  g1(52,24)=1;
  g1(53,23)=1-(params(15)+params(16));
  g1(54,10)=(-exp(y(10)));
  g1(54,31)=exp(y(31));
  g1(55,25)=1;
  g1(56,26)=1;
  g1(57,27)=1;
  g1(58,28)=1;
  g1(59,29)=1;
  g1(60,30)=1;
  g1(61,53)=(-1);
  g1(61,61)=1;
  g1(62,23)=(-1);
  g1(62,62)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],62,3844);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],62,238328);
end
end
end
end
